#include "asm.h"
#include "mipsasm.h"
#include "core.h"
#include "format.h"
SRCFILE("mipsasm.c")

MipsInstr::MipsInstr(Asm*a,long l):Instr(a,l)	{ display(); }
char *MipsAsm::literaldelimiter()		{ return "$"; }
MipsAsm::MipsAsm(Core *c):Asm(c)		{ }

Instr *MipsAsm::newInstr(long a)
{
	return (Instr*) new MipsInstr(this,a);
}

char *MipsInstr::arg(int)			{ return "arg"; } 
int MipsInstr::argtype(int)			{ return 0; }
int MipsInstr::nargs()				{ return 0; }

char *MipsInstr::mnemonic()
{
	static char buf[128];
	unsigned regmask, symbol_value, ls_register;

	m = *_asm->core->peekcode(addr);
	buf[0] = 0;
	disasm(buf, addr, m.lng, &regmask, &symbol_value, &ls_register);
	next = addr+4;
	return buf;
}
